#include <WinAPI.au3>
#include <Process.au3>
#include "Container.au3"

$oContainer = _Container_Open("storage", 0)

If @error Then
	MsgBox(48, 'Container', '_Container_Open() failed!')
	Exit
EndIf

$iPid = _Container_GetProperty($oContainer, "pid")
$pPtr = _Container_GetProperty($oContainer, "ptr")
$sStructTag = _Container_GetProperty($oContainer, "struct_tag")

$tStruct = _WinAPI_ReadProcessMemoryEx($iPid, $pPtr, $sStructTag)

MsgBox(0, "@error: " & @error, "Struct Size: " & DllStructGetSize($tStruct) & @CRLF & _
        "Struct pointer: " & DllStructGetPtr($tStruct) & @CRLF & @CRLF & _
        "Data from " & _ProcessGetName($iPid) & ":" & @CRLF & _
        DllStructGetData($tStruct, 1) & @CRLF & _
        DllStructGetData($tStruct, 2) & @CRLF & _
        DllStructGetData($tStruct, 3) & @CRLF & _
        DllStructGetData($tStruct, 4) & @CRLF & _
        DllStructGetData($tStruct, 4, 1))

Func _WinAPI_ReadProcessMemoryEx($iProcessID, $pPointer, $sStructTag)
	Local $iSYNCHRONIZE = (0x00100000), $iSTANDARD_RIGHTS_REQUIRED = (0x000F0000)
	Local $iPROCESS_ALL_ACCESS = ($iSTANDARD_RIGHTS_REQUIRED + $iSYNCHRONIZE + 0xFFF)
	Local $hProcess, $Struct, $StructPtr, $StructSize, $Read
	
	$hProcess = _WinAPI_OpenProcess($iPROCESS_ALL_ACCESS, False, $iProcessID)
	If @error Then Return SetError(@error, 1, $Struct)
	
	$Struct = DllStructCreate($sStructTag)
	$StructSize = DllStructGetSize($Struct)
	$StructPtr = DllStructGetPtr($Struct)
	
	_WinAPI_ReadProcessMemory($hProcess, $pPointer, $StructPtr, $StructSize, $Read)
	_WinAPI_CloseHandle($hProcess)
	
	Return SetError(@error, $Read, $Struct)
EndFunc
